//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_PropertyGraphics
{
    long    View_DateScale,
            View_PriceScale,
            Chart_Mode;
//+----------------+
    void SAVE(void)
    {
        View_DateScale = ChartGetInteger(0, CHART_SHOW_DATE_SCALE);
        View_PriceScale = ChartGetInteger(0, CHART_SHOW_PRICE_SCALE);
        Chart_Mode = ChartGetInteger(0, CHART_MODE);
    }
//+----------------+
    void RESTORE(void)
    {
        ChartSetInteger(0, CHART_SHOW_DATE_SCALE, View_DateScale);
        ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, View_PriceScale);
        ChartSetInteger(0, CHART_MODE, Chart_Mode);

        ChartRedraw();
    }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    st_PropertyGraphics StyleGraphic;

    StyleGraphic.SAVE();

    StyleGraphic.Chart_Mode = CHART_LINE;

    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, false);
    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, false);
    ChartSetInteger(0, CHART_MODE, CHART_BARS);
    ChartRedraw();

    Sleep(2000);
    
    StyleGraphic.RESTORE();
}
//+------------------------------------------------------------------+